def get_catch():
    place = input('Place: ')
    if place == '':
        return None
    fish = input('Type of fish: ')
    size = float(input('Size (inches): '))
    return place, fish, size


def get_catches():
    catches = []
    while True:
        catch = get_catch()
        if catch is None:
            break
        catches.append(catch)
    return catches


def get_types():
    types = []
    print('What types of fish do you want to report on?')
    while True:
        fish_type = input('Type: ')
        if fish_type == '':
            break
        types.append(fish_type)
    return types


def filter_to_type(catches, fish_type):
    keepers = []
    for place, fish, size in catches:
        if fish == fish_type:
            keepers.append((place, fish, size))
    return keepers


def get_average_size(catches):
    total = 0
    for place, fish, size in catches:
        total = total + size
    return total / len(catches)


def find_max(catches):
    best_fish = None
    best_place = None
    best_size = None
    for place, fish, size in catches:
        if best_size is None or size > best_size:
            best_size = size
            best_fish = fish
            best_place = place
    return best_place, best_fish, best_size

    
def print_type_report(catches, fish_type):
    catches = filter_to_type(catches, fish_type)
    ave_size = get_average_size(catches)
    place, fish, size = find_max(catches)
    
    print(f'Total # of {fish_type}: {len(catches)}')
    print(f'Average size for {fish_type}: {round(ave_size, 1)}')
    print(f'Best {fish} catch: {size} inches at {place}')
    

def print_reports(catches, types):
    for fish_type in types:
        print_type_report(catches, fish_type)
        

def main():
    catches = get_catches()
    types = get_types()
    print_reports(catches, types)


if __name__ == '__main__':
    main()
    
