def find_highest_temp(temperatures):
    highest_temp = None
    for city, state, temperature in temperatures:
        if highest_temp is None or temperature > highest_temp:
            hottest_city = city
            hottest_state = state
            highest_temp = temperature
    return hottest_city, hottest_state, highest_temp


def convert_to_fahrenheit(temperatures):
    new_temperatures = []
    for city, state, temperature, measurement in temperatures:
        if measurement == "Celsius":
            temperature = round(temperature * (9/5) + 32)
        new_temperatures.append((city, state, temperature))
    return new_temperatures


def main():
    # https://en.wikipedia.org/wiki/U.S._state_and_territory_temperature_extremes
    temperatures = [('Centreville', 'Alabama', 112, 'Fahrenheit'), ('Ozark', 'Arkansas', 48.9, 'Celsius'),
                    ('Phoenix', 'Arizona', 53.3, 'Celsius'), ('Millsboro', 'Delaware', 106, 'Fahrenheit'),
                    ('Collegeville', 'Indiana', 46.7, 'Celsius'), ('Lake Powell', 'Utah', 48.9, 'Celsius')]
    temperatures = convert_to_fahrenheit(temperatures)
    city, state, temp = find_highest_temp(temperatures)
    print(f"The highest temperature in the US was recorded in {city} {state}, at {temp} degrees Fahrenheit!")


if __name__ == '__main__':
    main()
